module net.BurtonRadons.spyl.expressionCatenate;

private import net.BurtonRadons.spyl.expression;
private import net.BurtonRadons.spyl.expressionBinary;
private import net.BurtonRadons.spyl.value;
private import net.BurtonRadons.spyl.mark;
private import net.BurtonRadons.spyl.scope;

class CatenateExpression : BinaryExpression
{
    /** Assign the parameters. */
    this (Mark mark, Expression a, Expression b)
    {
        super (mark, a, b);
    }
    
    override Value evaluate (Scope scope)
    {
        return a.evaluate (scope) ~ b.evaluate (scope);
    }
    
    override char [] toString ()
    {
        return subString (a) ~ " ~ " ~ subString (b);
    }
    
    override int precedence ()
    {
        return Precedence.Add;
    }
}